--this is a basic shooter for us...
require('g_level')

function create_fireball_shooter(from_x,from_y,to_x,to_y,layer)
    local shooter_sound_radius = 250.0
    local bullet_sound_radius = 50.0
    local bullet_sound = "data/music/effect_stereo.ogg"
    local shooter_sound = "data/music/effect_stereo.ogg"
    local bullet_speed = 0.1
    local dmg_start_script = "data/scripts/test/srt_stop_damage_test.lua"
    local dmg_end_script = "data/scripts/test/srt_start_damage_test.lua"
    local bullet_trigger_radius = 10.0
    local shot_time = 5.0

    --shooter starts
    local shooter_id = g_level.give_id(); 
    local bullet_id  = g_level.give_id();
    lua:create_shooter( shooter_id, from_x, from_y , layer);                  -- id, local origin x, y

    lua:shooter_set_idle_time(  shooter_id, shot_time, shot_time );        -- id, time 1, time 2

    lua:create_sprite("shooter_idle_animation",  ST_ANIMATED, "",0.0, 0.0)   -- sprite name, animated or not, animation name, translation x, y
    lua:sprite_shape("shooter_idle_animation",  ST_ANIMATED,40.0, 20.0)   -- name, type, width, height
    lua:sprite_color("shooter_idle_animation",1.0,1.0,1.0,0.0) --name,r,g,b,a

    lua:shooter_set_idle_animation( shooter_id, "shooter_idle_animation" );

    -- create sound for shooting effect
    lua:create_sound("shooter_shoot_sound", shooter_sound, shooter_sound_radius, from_x, from_y)  -- name, music_name, radius, x,y
    lua:shooter_add_shooting_effect(shooter_id, "shooter_shoot_sound")                                    -- shooter id, sound name
    lua:remove_sound_from_sounds_temp("shooter_shoot_sound")                                              -- sound name
    --shooter ends

    --bullet starts
    lua:create_bullet( shooter_id, bullet_id );            -- shooter id, bullet id -- lets just create bullet to our shooter, little stupid but anyway
    --bullet trigger
    lua:create_circle( "bullet_shape", 0, 0, bullet_trigger_radius);         -- shape with, 1 = shape with number of verticies, 5 = number of verticies

    lua:create_trigger( "bullet_trigger", TT_GATE, dmg_start_script,dmg_end_script, from_x,from_y)  --name, type, on_enter_script, on_leave_scipt,x,y  -- x and y should be very close to real start location
    lua:trigger_shape(  "bullet_trigger", TT_GATE, "bullet_shape")                --name, type, shape_name
    lua:trigger_add_group_i_belong_to( "bullet_trigger", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me(  "bullet_trigger", TT_GATE, "player")     --name, type, group_name

    lua:trigger_set_color(  "bullet_trigger", 0.5, 0.5, 0.5, 0.3);              --trigger name, red, green, blue, alpha
    lua:bullet_set_trigger( shooter_id, "bullet_trigger" );                     --shooter id, trigger name

    --Bullet graphics

    -- start coordinates , end coordinates are on last frame
    --lua:create_sprite("bullet_animation", ST_ANIMATED,"fireball", from_x, from_y)          -- name, textured, tex_name, x, y
    --lua:sprite_shape("bullet_animation",ST_ANIMATED,16.0, 16.0)
    --lua:remorfable_sprite("bullet_sprite", "bullet_animation", bullet_speed, false)                        -- name, sprite_name, speed, repeat
    --create the particle
    lua:create_sprite("prototype", ST_PARTICLE, "myParticle", from_x,from_y)  --the translation values can be anything. They must be there for integrity but they ain't used to anything.
    lua:sprite_shape("prototype", ST_PARTICLE, 10.0,10.0)
    lua:textured_sprite_tex_coords("prototype", ST_PARTICLE, 0.0, 0.0, 1.0, 1.0)
    lua:particle_start_color("prototype", 1.0, 1.0, 1.0, 0.5) -- name: rgba-colors
    lua:particle_end_color("prototype", 0.0, 0.0, 0.0, 0.0)

    -- create the emitter
    lua:create_sprite("emitter", ST_EMITTER, "prototype", from_x,from_y) -- the translation values are on, the "texture" is the teztured particle inserted.
    lua:emitter_range("emitter", 0.75, 1.5, -5.0, 5.0, 25.0, 75.0)  --life min & max, angular_velocity min & max, linear_velocity min & max
    lua:emitter_scale("emitter", true, 1.0, 3.0, 2.0, 4.0)  -- variable_scale, begin_scale_range min & max, end_scale_range min & max
    lua:emitter_target_layer("emitter", layer) -- target layer index
    lua:emitter_angle("emitter", 3.14) -- angle. (0-PI)
    lua:emitter_timer_delay("emitter", 0.005) -- the new timer delay

    lua:remorfable_sprite("bullet_sprite", "emitter", bullet_speed, false)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.99999999, to_x, to_y, 0.0, 1.0)        -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.25)                  -- r,g,b,a
    lua:upload_key_frame("bullet_sprite")

    --Bullet Graphics end
    lua:bullet_set_graphics(shooter_id, "bullet_sprite", layer) -- shooter id, sprite, bullet target layer
    lua:gameobject_remove_from_temp_list( "bullet_sprite" )

    --Bullet audio
    lua:create_sound("bullet_flying_sound", bullet_sound, bullet_sound_radius, from_x, from_y)  -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )
    lua:create_sound_effect("bullet_flying_sound", "bullet_flying_sound", 0.1, true)            -- object name, sound name, delay, loop
    lua:bullet_set_flying_sound(shooter_id, "bullet_flying_sound")                              -- shooter id, flying sound
    lua:gameobject_remove_from_temp_list( "bullet_flying_sound" )
    --bullet ends
end


--LOAD GRAPHICS
--lua_init_texture("fireball", "data/images/particle.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
--local delay = 0.125
--lua_init_subtexture_animation("fireball",4, 4, 1, 10, MODE_LOOP, DIRECTION_FORWARD,delay) --name,cols, rows, startf, endf, mode, direction,delay

lua_init_texture("myParticle", "data/images/myParticle.png", FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
